 ; Ŀ
 ;   Play - find all entities and subentities on a given layer.            
 ;   Copyright 1991, 2004, 2006, 2007 by Rocket Software Ltd.              
 ;   Software - four hours of work to teach a computer what a human could  
 ;   learn in five minutes.                                                
 ;                                                                         
 ;   Play is designed to find entities on layers which appear to be        
 ;   empty but can't be purged.                                            
 ;   It first checks the layer in question for overlooked entities and     
 ;   empty text strings.  Then it searches the block tables for            
 ;   subentities which are on the offending layer even though the block    
 ;   containing them isn't - if the layer on which the block is inserted   
 ;   is frozen these won't be visible, but they will still prevent the     
 ;   layer they are on from being purged.                                  
 ;                                                                         
 ;   Note that Play doesn't alter the blocks: that's up to you.            
 ;   Also be aware that if Play names a block which you can't find it is   
 ;   most likely nested within another block.  Wblock it out, use Ezlay    
 ;   to move the stuff on the offending layer to another one, reinsert     
 ;   and redefine it.                                                      
 ;                                                                         
 ;   It is generally a good idea to audit a drawing before trying to       
 ;   purge unwanted layers.                                                
 ;                                                                         
 ; 

 ; Ŀ
 ;   Blayo - get a list of the names of all layers in the drawing.         
 ;   Takes no arguments, calls nothing, returns a list.                    
 ; 
 (DEFUN BLAYO (/ rew nexb namm blist)
  (setq rew T)
  (while (setq nexb (tblnext "layer" rew))
         (setq rew ())
         (setq namm (cdr (assoc 2 nexb)))
         (setq blist (cons namm blist)))
 blist)
 ; Ŀ
 ;   Blayo end.                                                            
 ; 

 ; Ŀ
 ;   Blofa - see if any blocks have subentities on a named layer.          
 ;   Arguments: Layy, a layer name.                                        
 ;   Returns a list of block names.                                        
 ; 
 (DEFUN BLOFA (layy / rewind blok onlayer topnam namm bleent namm blox)
  (setq layy (strcase layy))
  (setq rewind t)                                   ; set the rewind flag
  (while (setq blok (tblnext "block" rewind))       ; next block in table
         (setq rewind ())                           ; clear the rewind flag
         (setq onlayer ())                          ; clear "on bad layer" flag
         (setq topnam (cdr (assoc 2 blok)))         ; block name
 ; Ŀ
 ;   Check to see if the first subentity is on the offending layer.        
 ; 
         (setq namm (cdr (assoc -2 blok)))          ; entity name
         (setq bleent (entget namm))                ; and entity data
         (if (= (strcase (cdr (assoc 8 bleent)))
                layy)                               ; if this subent on layer
             (setq onlayer T))                      ; then set the flag
 ; Ŀ
 ;   Step through the subentities, check to see if each one is on the      
 ;   layer.  If it is then set the "onlayer" flag.                         
 ; 
         (while (setq namm (entnext namm))          ; next entity after bl name
                (setq bleent (entget namm))         ; entity data
                (if (= (strcase (cdr (assoc 8 bleent)))
                       layy)                        ; if this subent on layer
                    (setq onlayer T)))              ; then set the flag
 ; Ŀ
 ;   Have now reached the end of the subentities for the block.  If the    
 ;   onlayer flag is set then some were on the stuck layer, so append      
 ;   the block name to the list of blocks.                                 
 ; 
         (if onlayer (setq blox (append blox (list topnam)))))
 blox)
 ; Ŀ
 ;   Blofa End.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Chowmein - search blocks for attributes on a given layer.  
 ;   Copyright 1994 by Rocket Software Ltd.                                
 ;   Play also searches the block tables, but an attribute may have been   
 ;   moved to a new layer independent of its parent block and thus might   
 ;   not match the block definition.                                       
 ;   "Sweet and sour chicken" was too long.                                
 ;   Arguments: Loc is the layer in question, Rad is the marker line       
 ;   half-legth, and Blox is the list of known bad blocks.                 
 ; 
 (DEFUN CHOWMEIN (loc rad blox / num nuf hi len enam esub namb bliss entt
                                                                       layy pa)
  (setq num 0)   ; position in ss
  (setq nuf 0)   ; strings found counter
 ; Ŀ
 ;   Get selection set of blocks with attributes.                          
 ; 
  (setq hi (getvar "highlight"))
  (setq ss (ssget "X" (list (cons 66 1) (cons 0 "INSERT"))))
  (setvar "highlight" hi)
  (if ss
     (progn
 ; Ŀ
 ;   Make length counter half-string.                                      
 ; 
  (setq len (strcat "/" (itoa (sslength ss))))
 ; Ŀ
 ;   While there are blocks in the selection set.                          
 ; 
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (grtext -2 (strcat (itoa num) len))
         (if (not (member (cdr (assoc 2 (entget enam))) blox))
             (progn
                 (setq esub (entnext enam))
                 (setq namb (cdr (assoc 2 (entget enam))))
                 (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget esub)))))
                        (setq layy (strcase (cdr (assoc 8 entt))))
                        (if (= layy loc)
                            (progn
                                 (if (not (member namb bliss))
                                     (setq bliss (append bliss (list namb))))
                                 (setq nuf (1+ nuf))
                                 (setq pa (cdr (assoc 10 entt)))
                                 (grdraw (polar pa (/ pi 4) rad)
                                         (polar pa (* 1.25 pi) rad) 7)
                                 (grdraw (polar pa (* pi 0.75) rad)
                                         (polar pa (* pi 1.75) rad) 7)))
                        (setq esub (entnext esub))))))
  (if bliss
     (progn
          (setq num 0)
          (setq bstrng "")
          (while (setq subb (nth num bliss))
                 (setq bstrng (strcat bstrng " " subb))
                 (setq num (1+ num)))
  (prompt (strcat "Insertions of the following block"
                  (if (> (length bliss) 1) "s" "")
                  " contained a total of " (itoa nuf)
                  " attribute" (if (> nuf 1) "s" "")
                  " located\non layer " loc " rather than on the layer"
                  (if (> (length bliss) 1) "s" "") " listed"
                  " in the block tables: " bstrng "."))))))
 nuf)
 ; Ŀ
 ;   Chowmein end.                                                         
 ; 

 ; Ŀ
 ;   Se - find all blocks which have a seqend on a given layer.            
 ;   Copyright 2001 by Rocket Software Ltd.                                
 ;   Arguments: Rad, the marker line length.                               
 ;              Loc, the layer to check.                                   
 ;   Returns T if any were found, else nil.                                
 ;                                                                         
 ;   Acad2000i currently leaves the Seqend entity on the layer on which    
 ;   the block containing it was inserted even if the block is moved to    
 ;   a different layer.  Se fixes this automatically: if the parent        
 ;   entity is on the layer to locate, the Seqend is moved to 0,           
 ;   otherwise it is moved to the parent entity layer.                     
 ;   This cuts out one pointless prompt and another pass through the       
 ;   database.  Moving Seqends if the parent entities are on the layer to  
 ;   locate prevents having to do a second pass if the parent entities     
 ;   are relayered.                                                        
 ;   Later: one apparently can't change the layer a seqend is on, but      
 ;   entmoding the parent entity to a different layer and then back to     
 ;   its original one also updates the seqend.                             
 ; 
 (DEFUN SE (loc rad / ss len num enam entt pa found)
 ; Ŀ
 ;   Get ss of multi-part entities, make length counter half-string.       
 ; 
  (if (setq ss (ssget "X" (list (cons 66 1) (cons 0 "insert"))))
      (setq len (strcat "/" (itoa (sslength ss)))))
 ; Ŀ
 ;   While there are blocks in the selection set.                          
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq esav enam)
         (setq pa (cdr (assoc 10 (setq entt (entget enam)))))
         (setq elay (cdr (assoc 8 entt)))
         (grtext -2 (strcat (itoa (setq num (1+ num))) len))
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam))))))))
         (if (= (strcase (cdr (assoc 8 entt))) loc)
             (progn
                  (setq found t)
                  (setq entt (entget esav))
                  (entmod (subst (cons 8 "0") (assoc 8 entt) entt))
                  (setq entt (entget esav))
                  (entmod (subst (cons 8 elay) (assoc 8 entt) entt))
                  (grdraw (polar pa (/ pi 4) rad)
                          (polar pa (* 1.25 pi) rad) 5)
                  (grdraw (polar pa (* pi 0.75) rad)
                          (polar pa (* pi 1.75) rad) 5))))
 found)
 ; Ŀ
 ;   Subroutine Se end.                                                    
 ; 

 ; Ŀ
 ;   Play - the show.                                                      
 ; 
 (Defun C:PLAY (/ rad layy ss ssd num nuf len so txa mmm lenn pa dell entfnd
                     rewind blok topnam namm bleent onlayer blox blist subb)
  (command "undo" "be")
  (setq rad (/ (- (car (getvar "extmax")) (car (getvar "extmin"))) 25))
 ; Ŀ
 ;   Get a layer either by text entry or from a dialog box.                
 ;   The latter requires the file Lager.lsp to be available.               
 ; 
  (setq layy (getstring T
              "Which layer are you trying to delete? <Return> for dialog: "))
  (if (= layy "")
      (progn
           (if (not lager) (load "lager" ()))
           (setq layy (lager (blayo)))))
  (setq layy (strcase layy))
  (setq uclayy (strcat (strcase (substr layy 1 1))
                       (strcase (substr layy 2) t)))
 ; Ŀ
 ;   First see if the layer exists.                                        
 ; 
  (if (tblsearch "layer" layy)
      (progn                   ; all but last two lines are in here
 ; Ŀ
 ;   Search the layer for empty text strings.                              
 ; 
  (setq ss (ssget "X" (list (cons 8 layy) (cons 0 "TEXT"))))
  (setq ssd (ssadd))
  (setq num 0)
  (setq nuf 0)
  (if ss
      (progn
          (setq len (strcat "/" (itoa (sslength ss))))
          (while (setq so (ssname ss 0))
                 (setq txa (entget so))
                 (setq num (1+ num))
                 (grtext -2 (strcat (itoa num) len))
                 (setq mmm (cdr (assoc 1 txa)))
                 (setq lenn (strlen mmm))
                 (while (and (> lenn 0) (= (substr mmm lenn 1) " "))
                        (setq lenn (1- lenn)))
                 (if (= lenn 0)
                     (progn
                           (setq pa (cdr (assoc 10 txa)))
                           (grdraw (polar pa (/ pi 4) rad)
                                   (polar pa (* 1.25 pi) rad) 7)
                           (grdraw (polar pa (* pi 0.75) rad)
                                   (polar pa (* pi 1.75) rad) 7)
                           (setq nuf (1+ nuf))
                           (ssadd so ssd)))
                 (ssdel so ss))))
 ; Ŀ
 ;   If there are any empty strings, prompt to delete them.                
 ; 
  (if (/= (setq nuf (sslength ssd)) 0)
      (progn
            (write-line (strcat "Empty text strings found: " (itoa nuf)))
            (setq dell (getstring "Delete them? <Y>: "))
            (if (or (= dell "Y") (= dell "y") (= dell ""))
                (progn
                    (command "erase" ssd "")
                    (write-line (strcat "Strings eradicated: " (itoa nuf)))))
            (setq entfnd T)))                 ; set entities found flag
 ; Ŀ
 ;   Now see if there are any other entities inserted directly on the      
 ;   layer and if so then mark them.                                       
 ; 
  (if (setq ss (ssget "X" (list (cons 8 layy))))
      (progn
           (setq num 0)
           (write-line (strcat "Entities on layer " uclayy
                               ": " (itoa (sslength ss))))
           (setq len (strcat "/" (itoa (sslength ss))))
           (while (setq so (ssname ss num))
                  (setq txa (entget so))
                  (setq num (1+ num))
                  (grtext -2 (strcat (itoa num) len))
                  (setq pa (cdr (assoc 10 txa)))
                  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) 7)
                  (grdraw (polar pa (* pi 0.75) rad)
                          (polar pa (* pi 1.75) rad) 7))
 ; Ŀ
 ;   And prompt to erase them.                                             
 ; 
           (setq dell (strcase (getstring "Delete them? <Y>: ")))
           (if (or (= dell "YES") (= dell "Y") (= dell ""))
               (command "erase" ss ""))
           (setq ss nil)
           (setq entfnd T)))                 ; set entities found flag
 ; Ŀ
 ;   Now search for block subentities on the layer.                        
 ;   If any were found spit out their names.                               
 ; 
  (if (setq blox (blofa layy))
      (progn
           (setq num 0)
           (setq blist "")
           (while (setq subb (nth num blox))
                  (setq blist (strcat blist "\n" subb))
                  (setq num (1+ num)))
           (write-line (strcat "Blocks with subentities on "
                                uclayy ":" blist))
           (setq entfnd T))                  ; set entities found flag
      (write-line (strcat "No block subentities found on " uclayy)))
 ; Ŀ
 ;   Call chowmein to look for relayered attributes.                       
 ; 
  (if (> (chowmein layy rad blox) 0) (setq entfnd T))
 ; Ŀ
 ;   Call Se to look for and automatically fix Seqend entities.            
 ; 
  (if (se layy rad)
      (write-line "Bad Seqend entities fixed (Blue X)"))
 ; Ŀ
 ;   If entfnd is nil then no entities were found: say so.                 
 ; 
  (if (null entfnd) (write-line "No problem entities found."))) ; first progend
 ; Ŀ
 ;   If there is no such layer:                                            
 ; 
  (write-line (strcat "There is no such layer as " uclayy ".")))
  (command "undo" "end")
 (princ))